<?php

if ($f == 'register') {
    if (!empty($_SESSION['user_id'])) {
        $_SESSION['user_id'] = '';
        unset($_SESSION['user_id']);
    }
    if (!empty($_COOKIE['user_id'])) {
        $_COOKIE['user_id'] = '';
        unset($_COOKIE['user_id']);
        setcookie('user_id', '', -1);
        setcookie('user_id', '', -1, '/');
    }
    
    $errors = '';
    $fields = Wo_GetWelcomeFileds();

    // === VALIDATION DES CHAMPS REQUIS DE TOUTES LES ÉTAPES ===
    if (empty($_POST['first_name']) || empty($_POST['last_name']) || empty($_POST['username']) || empty($_POST['email']) || empty($_POST['age']) || empty($_POST['country_id']) || empty($_POST['type_membre']) || empty($_POST['password']) || empty($_POST['confirm_password'])) {
        $errors = $error_icon . $wo['lang']['please_check_details'];
    } else {
        // --- Validations de base ---
        if (strlen($_POST['username']) < 5 || strlen($_POST['username']) > 32) {
            $errors = $error_icon . $wo['lang']['username_characters_length'];
        }
        if (!preg_match('/^[\w]+$/', $_POST['username'])) {
            $errors = $error_icon . $wo['lang']['username_invalid_characters'];
        }
        if (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
            $errors = $error_icon . $wo['lang']['email_invalid_characters']; 
        }
        if (!is_numeric($_POST['age']) || $_POST['age'] < 18) {
            $errors = $error_icon . $wo['lang']['check_18_age'];
        }
        
        // --- Validations de la base de données et de sécurité ---
        $is_exist = Wo_IsNameExist($_POST['username'], 0);
        if (is_array($is_exist) && $is_exist[0] === true) {
            $errors = $error_icon . $wo['lang']['username_exists'];
        }
        if (Wo_EmailExists($_POST['email'])) {
            $errors = $error_icon . $wo['lang']['email_exists'];
        }
        if (!empty($_POST['phone_number']) && Wo_PhoneExists($_POST['phone_number'])) {
            $errors = $error_icon . $wo['lang']['phone_already_used'];
        }
        if (Wo_IsBanned($_POST['username']) || Wo_IsBanned($_POST['email'])) {
            $errors = $error_icon . $wo['lang']['username_is_banned'];
        }
        if (in_array($_POST['username'], $wo['site_pages']) || ($wo['config']['reserved_usernames_system'] == 1 && in_array($_POST["username"], $wo['reserved_usernames']))) {
            $errors = $error_icon . $wo['lang']['username_invalid_characters'];
        }

        // --- Validation Mot de passe ---
        if (strlen($_POST['password']) < 6) {
            $errors = $error_icon . $wo['lang']['password_short'];
        }
        if ($_POST['password'] != $_POST['confirm_password']) {
            $errors = $error_icon . $wo['lang']['password_mismatch'];
        }

        // --- Validation des champs conditionnels de l'Étape 3 ---
        if ($_POST['type_membre'] == 'membre') {
            if (empty($_POST['orientation_sexuelle']) || empty($_POST['identite_genre'])) {
                $errors = $error_icon . $wo['lang']['required_orientation_sexuelle'];
            }
            if ($_POST['orientation_sexuelle'] == 'Autre' && empty($_POST['orientation_sexuelle_autre'])) {
                $errors = $error_icon . $wo['lang']['check_orientation_sexuelle'];
            }
            if ($_POST['identite_genre'] == 'Autre' && empty($_POST['identite_genre_autre'])) {
                $errors = $error_icon . $wo['lang']['check_identite_sexuelle'];
            }
        } elseif ($_POST['type_membre'] == 'PersonneRessource/Allié.e') {
            if (empty($_POST['statut_allie_ressource'])) {
                $errors = $error_icon . $wo['lang']['required_statut'];
            }
            if ($_POST['statut_allie_ressource'] == 'Autre' && empty($_POST['statut_allie_ressource_autre'])) {
                $errors = $error_icon . $wo['lang']['check_statut'];
            }
        } else if (empty($errors)) {
            $errors = $error_icon . $wo['lang']['check_type_member'];
        }
    }

    $field_data = array();
    if (empty($errors)) {
        // Gérer les champs personnalisés de WoWonder (s'il y en a)
        if (!empty($fields)) {
            foreach ($fields as $key => $field) {
                if (isset($_POST[$field['fid']])) {
                    $field_data[] = array($field['fid'] => $_POST[$field['fid']]);
                }
            }
        }
        
        // --- PRÉPARATION DES DONNÉES POUR L'ENREGISTREMENT ---
        $orientation_sexuelle = !empty($_POST['orientation_sexuelle']) ? (($_POST['orientation_sexuelle'] == 'Autre') ? Wo_Secure($_POST['orientation_sexuelle_autre']) : Wo_Secure($_POST['orientation_sexuelle'])) : '';
        $identite_genre = !empty($_POST['identite_genre']) ? (($_POST['identite_genre'] == 'Autre') ? Wo_Secure($_POST['identite_genre_autre']) : Wo_Secure($_POST['identite_genre'])) : '';
        $statut_allie_ressource = !empty($_POST['statut_allie_ressource']) ? (($_POST['statut_allie_ressource'] == 'Autre') ? Wo_Secure($_POST['statut_allie_ressource_autre']) : Wo_Secure($_POST['statut_allie_ressource'])) : '';

        $activate = ($wo['config']['emailValidation'] == '1') ? '0' : '1';
        $code     = md5(rand(1111, 9999) . time());
        
        $re_data  = array(
            'username' => Wo_Secure($_POST['username'], 0),
            'email' => Wo_Secure($_POST['email'], 0),
            'password' => $_POST['password'],
            'email_code' => Wo_Secure($code, 0),
            'src' => 'site',
            'gender' => 'male',
            'lastseen' => time(),
            'active' => Wo_Secure($activate),
            'first_name' => Wo_Secure($_POST['first_name']),
            'last_name' => Wo_Secure($_POST['last_name']),
            'age' => Wo_Secure($_POST['age']),
            'pronoun' => Wo_Secure($_POST['pronoun']),
            'country_id' => Wo_Secure($_POST['country_id']),
            'city' => Wo_Secure($_POST['city']),
            'phone_number' => Wo_Secure($_POST['phone_number']),
            'type_membre' => Wo_Secure($_POST['type_membre']),
            'orientation_sexuelle' => $orientation_sexuelle,
            'identite_genre' => $identite_genre,
            'statut_allie_ressource' => $statut_allie_ressource
        );

        // Assigner le rôle admin
        if ($_POST['type_membre'] == 'PersonneRessource/Allié.e') {
            $re_data['admin'] = '2'; // 2 = Admin, 1 = Modérateur
        }
        
        $register = Wo_RegisterUser($re_data);
        
        if ($register === true) {
            $user_id = Wo_UserIdFromUsername($_POST['username']);
            if (!empty($field_data)) { Wo_UpdateUserCustomData($user_id, $field_data, false); }
            
            if ($activate == 1) {
                $login = Wo_Login($_POST['username'], $_POST['password']);
                if ($login === true) {
                    $session = Wo_CreateLoginSession($user_id);
                    $_SESSION['user_id'] = $session;
                    setcookie("user_id", $session, time() + (10 * 365 * 24 * 60 * 60));
                }
                
                if (!empty($wo['config']['auto_friend_users'])) Wo_AutoFollow($user_id);
                
                $data = array(
                    'status' => 200,
                    'message' => $success_icon . $wo['lang']['successfully_joined_label'],
                    'location' => Wo_SeoLink('index.php?link1=start-up')
                );
            } else { 
                $wo['code'] = $code;
                $body = Wo_LoadPage('emails/activate');
                $send_message_data = array(
                    'from_email' => $wo['config']['siteEmail'], 'from_name' => $wo['config']['siteName'],
                    'to_email' => $_POST['email'], 'to_name' => $_POST['username'],
                    'subject' => $wo['lang']['account_activation'], 'charSet' => 'utf-8',
                    'message_body' => $body, 'is_html' => true
                );
                Wo_SendMessage($send_message_data);
                $errors = $success_icon . $wo['lang']['successfully_joined_verify_label'];
            }
        } else {
            $errors = $error_icon . $wo['lang']['error_found_please_try_again_later'];
        }
    }

    header("Content-type: application/json");
    if (!empty($errors)) {
        echo json_encode(array('errors' => $errors));
    } else {
        echo json_encode($data);
    }
    exit();
}