<?php
// On charge l'environnement WoWonder pour avoir accès aux fonctions et à la base de données
require_once('assets/init.php');

// --- SÉCURITÉ ---
// 1. L'utilisateur doit être connecté
if ($wo['loggedin'] == false) {
    header("Location: " . $wo['config']['site_url']);
    exit();
}
// 2. L'ID de la preuve doit être fourni et valide
if (empty($_GET['evidence_id']) || !is_numeric($_GET['evidence_id'])) {
    die("Fichier non trouvé.");
}
$evidence_id = Wo_Secure($_GET['evidence_id']);

// 3. Récupérer les informations de la preuve depuis la base de données
$evidence = $db->where('id', $evidence_id)->getOne(T_CASE_EVIDENCES);
if (empty($evidence)) {
    die("Fichier non trouvé.");
}

// 4. POLITIQUE DE PERMISSION : Vérifier si l'utilisateur a le droit de voir le cas associé à cette preuve
if (Wo_CanViewCase($evidence->case_id) === false) {
    die("Accès non autorisé.");
}

// 5. Forcer le téléchargement du fichier
$filepath = $evidence->file_path;

// Vérifie si le fichier existe sur le serveur
if (file_exists($filepath)) {
    header('Content-Description: File Transfer');
    header('Content-Type: ' . $evidence->mime_type);
    header('Content-Disposition: attachment; filename="' . basename($evidence->file_name) . '"');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . filesize($filepath));
    readfile($filepath);
    exit;
} else {
    die("Le fichier source est introuvable sur le serveur.");
}