<?php
// On charge l'environnement WoWonder
require_once('assets/init.php');

// Sécurité : Seuls les admins et modérateurs/agents peuvent exporter
if ($wo['loggedin'] == false || (Wo_IsAdmin() == false && Wo_IsModerator() == false)) {
    header("Location: " . $wo['config']['site_url']);
    exit();
}

// On inclut les bibliothèques
require_once('assets/libraries/PhpSpreadsheet/vendor/autoload.php');
require_once('assets/libraries/DomPDF/autoload.php');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Dompdf\Dompdf;
use Dompdf\Options;

$type = $_GET['type'] ?? '';
$format = $_GET['format'] ?? '';

if ($type == 'cases' && $format == 'excel') {
    // --- LOGIQUE POUR EXCEL ---
    $filtered_data = Wo_GetCases($_GET); // On réutilise notre fonction de filtre !
    $cases = $filtered_data['cases'];

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setTitle('Liste des Cas');

    // En-têtes
    $sheet->setCellValue('A1', 'ID Cas');
    $sheet->setCellValue('B1', 'Statut');
    $sheet->setCellValue('C1', 'Priorité');
    $sheet->setCellValue('D1', 'Agents Assignés');
    $sheet->setCellValue('E1', 'Date de Création');
    $sheet->setCellValue('F1', 'Description');

    // Données
    $rowNumber = 2;
    foreach ($cases as $case) {
        $agent_names = array_map(fn($a) => $a['name'], $case->assigned_agents);
        
        $sheet->setCellValue('A' . $rowNumber, '#' . $case->id);
        $sheet->setCellValue('B' . $rowNumber, ucfirst(str_replace('_', ' ', $case->status)));
        $sheet->setCellValue('C' . $rowNumber, ucfirst($case->urgency_level));
        $sheet->setCellValue('D' . $rowNumber, implode(', ', $agent_names));
        $sheet->setCellValue('E' . $rowNumber, date('d/m/Y', $case->time));
        $sheet->setCellValue('F' . $rowNumber, $case->description);
        $rowNumber++;
    }

    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="export_cas_xomiton.xlsx"');
    header('Cache-Control: max-age=0');
    
    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit();

} elseif ($type == 'cases' && $format == 'pdf') {
    // --- LOGIQUE POUR PDF ---
    $filtered_data = Wo_GetCases($_GET);
    $cases = $filtered_data['cases'];

    $options = new Options();
    $options->set('isHtml5ParserEnabled', true);
    $dompdf = new Dompdf($options);
    
    // On passe les données à un template HTML simple
    ob_start();
    include('admin-panel/pages/liste-cas/pdf_template.phtml'); // On va créer ce template
    $html = ob_get_clean();
    
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'landscape');
    $dompdf->render();
    $dompdf->stream("export_cas_xomiton.pdf", array("Attachment" => 1));
    exit();
}